/************************************************************************************/
/* format the 2002 data                                                             */
/************************************************************************************/

use "$directory/Pew/2002/pew_gap_final_44_country_dataset_1_1sav.dta", clear /* This is the file distributed by Pew*/
gen wt=weight
gen year=2002
gen sex=2-q73

gen str3 cty=""
replace cty="AGO" if country==1
replace cty="ARG" if country==2
replace cty="BGD" if country==3
replace cty="BOL" if country==4
replace cty="BRA" if country==5
replace cty="BGR" if country==6
replace cty="CAN" if country==7
replace cty="CHN" if country==8
replace cty="CIV" if country==9
replace cty="CZE" if country==10
replace cty="EGY" if country==11
replace cty="FRA" if country==12
replace cty="DEU" if country==13
replace cty="GHA" if country==14
replace cty="GTM" if country==15
replace cty="HND" if country==16
replace cty="IND" if country==17
replace cty="IDN" if country==18
replace cty="ITA" if country==19
replace cty="JPN" if country==20
replace cty="KEN" if country==21
replace cty="KOR" if country==22
replace cty="MLI" if country==23
replace cty="MEX" if country==24
replace cty="NGA" if country==26
replace cty="PAK" if country==27
replace cty="PER" if country==28
replace cty="PHL" if country==29
replace cty="POL" if country==30
replace cty="RUS" if country==31
replace cty="SEN" if country==32
replace cty="SVK" if country==33
replace cty="ZAF" if country==34
replace cty="TZA" if country==35
replace cty="TUR" if country==36
replace cty="UGA" if country==37
replace cty="GBR" if country==38
replace cty="UKR" if country==39
replace cty="USA" if country==40
replace cty="UZB" if country==41
replace cty="VEN" if country==42
replace cty="VNM" if country==43
replace cty="LBN" if country==44
replace cty="JOR" if country==45

gen sat=q2
replace sat=. if sat>10
gen today=3 if q1==2
replace today=1 if q1==3
replace today=2 if q1==1

compress
save "$directory/Pew/Pew2002_micro", replace 

/************************************************************************************/
/* format the 2007 data                                                             */
/************************************************************************************/
use "$directory/Pew/2007/gap_2007_data.dta", clear

gen wt=weight
gen year=2007

gen sat=q2
replace sat=. if sat>10
gen today=4-q1 if q1<4

gen str3 cty=""
replace cty="ARG" if country==1
replace cty="BGD" if country==2
replace cty="BOL" if country==3
replace cty="BRA" if country==4
replace cty="BGR" if country==5
replace cty="CAN" if country==6
replace cty="CHL" if country==7
replace cty="CHN" if country==8
replace cty="CZE" if country==9
replace cty="EGY" if country==10
replace cty="ETH" if country==11
replace cty="FRA" if country==12
replace cty="DEU" if country==13
replace cty="GHA" if country==14
replace cty="GBR" if country==15
replace cty="IND" if country==16
replace cty="IDN" if country==17
replace cty="ISR" if country==18
replace cty="ITA" if country==19
replace cty="CIV" if country==20
replace cty="JPN" if country==21
replace cty="JOR" if country==22
replace cty="KEN" if country==23
replace cty="KWT" if country==24
replace cty="LBN" if country==25
replace cty="MYS" if country==26
replace cty="MLI" if country==27
replace cty="MEX" if country==28
replace cty="MAR" if country==29
replace cty="NGA" if country==30
replace cty="PAK" if country==31
replace cty="PSE" if country==32
replace cty="PER" if country==33
replace cty="POL" if country==34
replace cty="RUS" if country==35
replace cty="SEN" if country==36
replace cty="SVK" if country==37
replace cty="ZAF" if country==38
replace cty="KOR" if country==39
replace cty="ESP" if country==40
replace cty="SWE" if country==41
replace cty="TZA" if country==42
replace cty="TUR" if country==43
replace cty="USA" if country==44
replace cty="UGA" if country==45
replace cty="UKR" if country==46
replace cty="VEN" if country==47

compress

save "$directory/Pew/Pew2007_micro", replace

/************************************************************************************/
/* format the 2010 data                                                             */
/************************************************************************************/
use "$directory/Pew/2010/pew_global_attitudes_spring_2010_dataset_for_release", clear

gen wt=weight
gen year=2010

gen sat=q2a
replace sat = q2b if missing(q2a) & !missing(q2b) /* telephone version */
replace sat=. if sat>10
gen today = q1
recode today (1=2) (2=3) (3=1) (8 9 = .), test

gen str3 cty=""
replace cty = "ARG" if country == 1
replace cty = "BRA" if country == 2
replace cty = "GBR" if country == 3
replace cty = "CHN" if country == 4
replace cty = "EGY" if country == 5
replace cty = "FRA" if country == 6
replace cty = "DEU" if country == 7
replace cty = "IND" if country == 8
replace cty = "IDN" if country == 9
replace cty = "JPN" if country == 10
replace cty = "JOR" if country == 11
replace cty = "KEN" if country == 12
replace cty = "LBN" if country == 13
replace cty = "MEX" if country == 14
replace cty = "NGA" if country == 15
replace cty = "PAK" if country == 16
replace cty = "POL" if country == 17
replace cty = "RUS" if country == 18
replace cty = "KOR" if country == 19
replace cty = "ESP" if country == 20
replace cty = "TUR" if country == 21
replace cty = "USA" if country == 22
assert !missing(cty)

compress
save "$directory/Pew/Pew2010_micro", replace

use "$directory/Pew/Pew2010_micro", clear
gen wave=2010
append using "$directory/Pew/Pew2007_micro"
replace wave=2007 if wave==.
append using "$directory/Pew/Pew2002_micro"
replace wave=2002 if wave==.

/* many countries have nonrepresentative sampling frames */
* Source: http://www.pewglobal.org/database/about/
* And see codebooks for each year

gen nonrepresentative = 0
replace nonrepresentative = 1 if cty == "AGO" & year == 2002
replace nonrepresentative = 1 if cty == "BOL" & year == 2002
replace nonrepresentative = 1 if cty == "BRA" & year == 2002
replace nonrepresentative = 1 if cty == "CHN" & year == 2002
replace nonrepresentative = 1 if cty == "EGY" & year == 2002
replace nonrepresentative = 1 if cty == "GTM" & year == 2002
replace nonrepresentative = 1 if cty == "HND" & year == 2002
replace nonrepresentative = 1 if cty == "IND" & year == 2002
replace nonrepresentative = 1 if cty == "IDN" & year == 2002
replace nonrepresentative = 1 if cty == "CIV" & year == 2002
replace nonrepresentative = 1 if cty == "MLI" & year == 2002
replace nonrepresentative = 1 if cty == "PAK" & year == 2002
replace nonrepresentative = 1 if cty == "SEN" & year == 2002
replace nonrepresentative = 1 if cty == "VEN" & year == 2002
replace nonrepresentative = 1 if cty == "VNM" & year == 2002
replace nonrepresentative = 1 if cty == "BOL" & year == 2007
replace nonrepresentative = 1 if cty == "BRA" & year == 2007
replace nonrepresentative = 1 if cty == "CHN" & year == 2007
replace nonrepresentative = 1 if cty == "IND" & year == 2007
replace nonrepresentative = 1 if cty == "CIV" & year == 2007
replace nonrepresentative = 1 if cty == "PAK" & year == 2007
replace nonrepresentative = 1 if cty == "ZAF" & year == 2007
replace nonrepresentative = 1 if cty == "VEN" & year == 2007

replace nonrepresentative = 1 if cty == "IND" & year == 2010

drop country
merge m:1 cty year using "$directory/gdp/Complete_GDP", keep(master match)
assert _merge==3
drop _merge

/* Make z-score for sat */
sum sat [aw=wt]
gen sat_z_all = (sat - r(mean))/r(sd)
local mean = r(mean)
gen sat_mean_all = `mean'
gen sat_sd_all = r(sd)

xi: reg sat i.cty i.wave [aw=wt]
predict sat_res if !missing(sat), residual
sum sat_res [aw=wt]
local sd=r(sd)
gen sat_z = (sat-`mean')/r(sd)
char sat_z[mean] "`mean'"
char sat_z[sd] "`sd'"
compress
save "$directory/Pew/Pew_micro", replace
for X in num 2010 2007 2002: rm "$directory/Pew/PewX_micro.dta"


/********************************************************************/
/* Aggregate into macro data                                        */
/********************************************************************/
collapse (mean) sat* nonrepresentative gdp lgdp [aw=wt], by(cty wave)
char sat_z[mean] "`mean'"
char sat_z[sd] "`sd'"
compress
save "$directory/Pew/Pew_macro", replace
rm "$directory/Pew/Pew_micro.dta"

